/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;

public class EntityAIMournCitizen
extends Goal {
    private final TickRateStateMachine<MourningState> stateMachine;
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<MourningState>(MourningState.IDLE, e -> Log.getLogger().warn("Mourning AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(this::shouldMourn, () -> MourningState.IDLE, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.IDLE, () -> true, this::decide, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDERING, () -> true, this::wander, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.STARING, () -> true, this::stare, 20));
    }

    private boolean shouldMourn() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.MOURN && this.citizen.func_70681_au().nextInt(300) < 1) {
            this.citizen.getCitizenData().getCitizenMournHandler().clearDeceasedCitizen();
            this.citizen.getCitizenData().getCitizenMournHandler().setMourning(false);
            this.citizen.getCitizenData().setVisibleStatus(null);
            return true;
        }
        return false;
    }

    private MourningState walkToTownHall() {
        BlockPos pos = this.getMournLocation();
        this.citizen.getNavigation().moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.speed);
        return MourningState.IDLE;
    }

    private MourningState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return MourningState.IDLE;
    }

    private MourningState stare() {
        if (this.citizen.func_70681_au().nextInt(200) < 1) {
            this.closestEntity = null;
            return MourningState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.field_70170_p.func_217360_a(EntityCitizen.class, EntityPredicate.field_221016_a, (LivingEntity)this.citizen, this.citizen.func_226277_ct_(), this.citizen.func_226278_cu_(), this.citizen.func_226281_cx_(), this.citizen.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return MourningState.IDLE;
            }
        }
        this.citizen.func_70671_ap().func_75650_a(this.closestEntity.func_226277_ct_(), this.closestEntity.func_226278_cu_() + (double)this.closestEntity.func_70047_e(), this.closestEntity.func_226281_cx_(), (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        return MourningState.STARING;
    }

    private MourningState decide() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN) {
            return MourningState.IDLE;
        }
        if (!this.citizen.getNavigation().func_75500_f()) {
            return MourningState.IDLE;
        }
        if (this.citizen.getCitizenStatusHandler().getStatus() != Status.MOURN) {
            this.citizen.getCitizenItemHandler().removeHeldItem();
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.MOURNING);
            this.citizen.getCitizenStatusHandler().setStatus(Status.MOURN);
            return MourningState.WALKING_TO_TOWNHALL;
        }
        this.citizen.func_70671_ap().func_75650_a(this.citizen.func_226277_ct_(), this.citizen.func_226278_cu_() - 10.0, this.citizen.func_226281_cx_(), (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        if (BlockPosUtil.getDistance2D(this.citizen.func_233580_cy_(), this.getMournLocation()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        if (this.citizen.func_70681_au().nextBoolean()) {
            return MourningState.STARING;
        }
        return MourningState.WANDERING;
    }

    public boolean func_75250_a() {
        this.stateMachine.tick();
        return this.stateMachine.getState() != MourningState.IDLE;
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    public void func_75251_c() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    protected BlockPos getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return this.citizen.func_213384_dI();
        }
        return colony.getBuildingManager().getTownHall().getPosition();
    }

    public static enum MourningState implements IState
    {
        IDLE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING;

    }
}

